/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define Time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

//  nanoreload@gmail.com	?????? ?.?.	https://vk.com/nano_hyper_active
//  ????????? +?????????
 
#ifdef GL_ES
precision highp float;
#endif

// uniform float time;
// varying vec2 surfacePosition;
// uniform vec2 mouse;
// uniform vec2 resolution;

#define R length(surfacePosition)*4.13
#define TH atan(surfacePosition.x, surfacePosition.y)
#define time Time + sin(R+TH*6.0-Time)/R*.0055

float makePoint(float x,float y,float fx,float fy,float sx,float sy,float t)
{
   float xx=x+sin(t*fx)*sx;
   float yy=y+cos(t*fy)*sy;
   return 0.54/sqrt(xx*xx+yy*yy);
}

vec3 gu(vec4 a,vec4 b,float f)
{
  return mix(a.xyz,b.xyz,(f-a.w)*(1.0/(b.w-a.w)));
}

vec3 grad(float f)
{
	vec4 c01=vec4(0.0,0.0,0.0,0.00);
	vec4 c02=vec4(0.5,0.0,0.0,0.50);
	vec4 c03=vec4(1.0,0.0,0.0,0.55);
	vec4 c04=vec4(1.0,1.0,0.0,0.80);
	vec4 c05=vec4(1.0,1.0,1.0,1.00);
	return (f<c02.w)?gu(c01,c02,f):
	(f<c03.w)?gu(c02,c03,f):
	(f<c04.w)?gu(c03,c04,f):
	gu(c04,c05,f);
}

void main( void ) 
{
   vec2 p=(scaled_gl_FragCoord.xy/resolution.x)*2.0-vec2(1.,resolution.y/resolution.x);

   //p=p*2.0;
   
   float x=p.x;
   float y=p.y;

   float a=
       makePoint(x,y,3.3,2.9,0.3,0.3,time);
   a=a+makePoint(x,y,1.9,2.0,0.4,0.4,time);
   a=a+makePoint(x,y,0.8,0.7,0.4,0.5,time);
   a=a+makePoint(x,y,2.3,0.1,0.6,0.3,time);
   a=a+makePoint(x,y,0.8,1.7,0.5,0.4,time);
   a=a+makePoint(x,y,0.3,1.0,0.4,0.4,time);
   a=a+makePoint(x,y,1.4,1.7,0.4,0.5,time);
   a=a+makePoint(x,y,1.3,2.1,0.6,0.3,time);
   a=a+makePoint(x,y,1.8,1.7,0.5,0.4,time);   
   a=a+makePoint(x,y,1.2,1.9,0.3,0.3,time);
   a=a+makePoint(x,y,0.7,2.7,0.4,0.4,time);
   a=a+makePoint(x,y,1.4,0.6,0.4,0.5,time);
   a=a+makePoint(x,y,2.6,0.4,0.6,0.3,time);
   a=a+makePoint(x,y,0.7,1.4,0.5,0.4,time);
   a=a+makePoint(x,y,0.7,1.7,0.4,0.4,time);
   a=a+makePoint(x,y,0.8,0.5,0.4,0.5,time);
   a=a+makePoint(x,y,1.4,0.9,0.6,0.3,time);
   a=a+makePoint(x,y,0.7,1.3,0.5,0.4,time);
   a=a+makePoint(x,y,3.7,0.3,0.3,0.3,time);
   a=a+makePoint(x,y,1.9,1.3,0.4,0.4,time);
   a=a+makePoint(x,y,0.8,0.9,0.4,0.5,time);
   a=a+makePoint(x,y,1.2,1.7,0.6,0.3,time);
   a=a+makePoint(x,y,0.3,0.6,0.5,0.4,time);
   a=a+makePoint(x,y,0.3,0.3,0.4,0.4,time);
   a=a+makePoint(x,y,1.4,0.8,0.4,0.5,time);
   a=a+makePoint(x,y,0.2,0.6,0.6,0.3,time);
   a=a+makePoint(x,y,1.3,0.5,0.5,0.4,time);
   
   vec3 a1=grad(a/128.0);
   
   gl_FragColor = vec4(a1.x,a1.y,a1.z,length(a1));
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}